"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerPlugin = void 0;
var _operators = require("rxjs/operators");
var _applications = require("./applications");
var _config_service = require("../common/config_service");
var _searchguard = _interopRequireDefault(require("./applications/searchguard/backend/searchguard"));
var _searchguard_configuration_backend = _interopRequireDefault(require("./applications/searchguard/configuration/backend/searchguard_configuration_backend"));
var _multitenancy = require("./applications/multitenancy");
var _ReadOnlyMode = require("./applications/searchguard/authorization/ReadOnlyMode");
/*
 *    Copyright 2021 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

async function getConfigService({
  kibanaIndex,
  logger,
  initContext,
  clusterClient
}) {
  try {
    const [kibanaConfig, sgConfig] = await Promise.all([initContext.config.legacy.globalConfig$.pipe((0, _operators.first)()).toPromise(), initContext.config.create().pipe((0, _operators.first)()).toPromise()]);

    // We most likely don't have any kibana config here,
    // so we add the index name manually.
    let extendedKibanaConfig = {
      ...kibanaConfig,
      kibana: {
        ...kibanaConfig.kibana,
        index: kibanaIndex
      }
    };

    // This will be updated in the setup and start methods.
    // Unfortunately, calling the required endpoint and
    // awaiting the response seems to lead to some
    // kind of race condition. As a result, some
    // of the routes are never enabled.
    sgConfig.multitenancy.enabled = true;
    return new _config_service.ConfigService({
      ...extendedKibanaConfig,
      elasticsearch: clusterClient.config,
      searchguard: sgConfig
    });
  } catch (error) {
    logger.error(`Failed to fetch the Kibana config, ${error}`);
    throw error;
  }
}
class ServerPlugin {
  constructor(initializerContext) {
    this.logger = initializerContext.logger.get();
    this.initContext = initializerContext;
    this.signalsApp = new _applications.Signals(this.initContext);
    this.searchGuardApp = new _applications.SearchGuard(this.initContext);
    this.multiTenancyApp = new _applications.Multitenancy(this.initContext);
    this.authTokensApp = new _applications.AuthTokens(this.initContext);
    this.kibanaIndex = '.kibana';
    this.readOnlyMode = null;
  }

  /*
  ATTENTION! Kibana imposes restrictions to the plugin lifecycle methods:
  1. A method must not return promise.
  2. A method execution time limit is 10 seconds.
  */
  setup(core, pluginDependencies) {
    process.on('unhandledRejection', error => {
      console.error(error); // This prints error with stack included (as for normal errors)
    });
    this.kibanaRouter = core.http.createRouter();

    // Register a switcher for the read only mode
    core.capabilities.registerSwitcher(async (request, uiCapabilities) => {
      if (this.readOnlyMode) {
        return this.readOnlyMode.switcherHandler(request, uiCapabilities);
      }
      return uiCapabilities;
    }, {
      capabilityPath: '*'
    });
    (async () => {
      const [{
        elasticsearch,
        savedObjects
      }] = await core.getStartServices();
      // The core.savedObjects interface in setup() is different from in start()
      // so we need to pass an instance variable to the config service

      this.kibanaIndex = core.savedObjects.getDefaultIndex();
      const configService = await getConfigService({
        kibanaIndex: this.kibanaIndex,
        logger: this.logger,
        initContext: this.initContext,
        clusterClient: elasticsearch.client
      });
      const searchGuardBackend = new _searchguard.default({
        elasticsearch,
        configService,
        core
      });
      const searchGuardConfigurationBackend = new _searchguard_configuration_backend.default({
        elasticsearch
      });
      if (configService.get('searchguard.readonly_mode.enabled')) {
        this.readOnlyMode = new _ReadOnlyMode.ReadOnlyMode(this.initContext.logger.get('searchguard-readonly'));
        this.readOnlyMode.setupSync({
          kibanaCoreSetup: core,
          searchGuardBackend,
          configService
        });
      }
      const tenantService = new _multitenancy.TenantService({
        clusterClient: elasticsearch.client,
        logger: this.logger,
        configService,
        savedObjects,
        coreContext: this.initContext
      });
      const spacesService = new _multitenancy.SpacesService({
        kibanaVersion: this.initContext.env.packageInfo.version,
        tenantService
      });
      const {
        authManager,
        sessionStorageFactory,
        kerberos
      } = await this.searchGuardApp.setup({
        core,
        pluginDependencies,
        configService,
        kibanaRouter: this.kibanaRouter,
        searchGuardBackend,
        searchGuardConfigurationBackend,
        spacesService,
        elasticsearch
      });

      // Helper for the routes
      core.http.registerRouteHandlerContext('searchGuard', () => {
        return {
          sessionStorageFactory,
          authManager,
          configService,
          startContext: {
            savedObjects
          }
        };
      });
      this.multiTenancyApp.setup({
        kibanaRouter: this.kibanaRouter,
        authManager,
        kerberos,
        kibanaCore: core,
        sessionStorageFactory,
        pluginDependencies,
        searchGuardBackend,
        configService,
        spacesService,
        tenantService,
        savedObjects,
        elasticsearch
      });
    })();
  }
  start(core) {
    (async () => {
      const configService = await getConfigService({
        kibanaIndex: this.kibanaIndex,
        logger: this.logger,
        initContext: this.initContext,
        clusterClient: core.elasticsearch.client
      });
      const searchGuardBackend = new _searchguard.default({
        elasticsearch: core.elasticsearch,
        configService,
        core
      });
      this.signalsApp.start({
        core,
        kibanaRouter: this.kibanaRouter,
        searchguardBackendService: searchGuardBackend
      });
      this.authTokensApp.start({
        core,
        kibanaRouter: this.kibanaRouter
      });
      this.multiTenancyApp.start({
        core,
        searchGuardBackend,
        configService,
        kibanaRouter: this.kibanaRouter,
        elasticsearch: core.elasticsearch
      });
    })();
  }
}
exports.ServerPlugin = ServerPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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